/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.alignmenttools.io;

import dk.kvl.alignmenttools.*;
import java.io.*;
import java.util.*;
import dk.kvl.sequencetools.*;

public class WideFileWriter extends BufferedWriter implements AlignmentWriter
{
    private Alignment alignment = null;
    private File file = null;
    private int longestName = -1;
    public WideFileWriter(Alignment alignment, File file) throws IOException
    {
        super(new FileWriter(file));
        this.alignment = alignment;
        setLongestName();
        writeAlignment();
        close();
    }
    
    public boolean writeTitle(String name)throws IOException
    {
        write (name,0,name.length());
        String blank = "                                                                           ";
        write (blank,0,longestName-name.length()+2);
        return true;
    }
    
    protected void writeLine(char[] line) throws IOException
    {
        write(line, 0, line.length);
        newLine();
    }
    
    protected void writeAlignment() throws IOException
    {
        /*Enumeration e = alignment.getPairingMaskKeys();
        while(e.hasMoreElements())
        {
            PairingMask mask =alignment.getPairingMask((String)e.nextElement());
            writeTitle(mask.getLabel());
            writeLine(mask.getSequenceArray());
        }
        */
        PairingMask mask =alignment.getPairingMask();
        if(mask != null)
        {
        writeTitle(mask.getLabel());
        writeLine(mask.getSequenceArray());
        }
        
        
        //Enumeration e = alignment.getSequenceKeys();
        String[] names = alignment.getSortedNames();
        for(int i = 0;i<names.length;i++)
        {
          Sequence seq = alignment.getSequence(names[i]);
          writeTitle(seq.getLabel());
          writeLine(seq.getSequenceArray());
        }
        /*while(e.hasMoreElements())
        {
            Sequence seq = alignment.getSequence((String)e.nextElement());
            writeTitle(seq.getLabel());
            writeLine(seq.getSequenceArray());
        }*/
    }
    
    public void setLongestName()
    {
      if(alignment.getPairingMask() != null)
      {
      Enumeration p = alignment.getPairingMaskKeys();
      while(p.hasMoreElements())
      {
        String s = (String)p.nextElement();
        if(s.length() > longestName)
        {
          longestName = s.length();
        }
      }
      }
      Enumeration e = alignment.getSequenceKeys();
      while(e.hasMoreElements())
      {
        String s = (String)e.nextElement();
        if(s.length() > longestName)
        {
          longestName = s.length();
        }
      }
    }
}
