/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/

package dk.kvl.controller;

import java.io.*;
import java.util.*;
import dk.kvl.tools.*;
import org.apache.xerces.parsers.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;
import dk.kvl.gui.properties.*;
import javax.swing.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    February 9, 2004
 */
public class ProgramController implements ErrorHandler
{

    private final Document document;
    private Hashtable programs = new Hashtable();

    public ProgramController() throws ParserConfigurationException, SAXException, IOException    
    {
	this(new File(AlignmentProperties.getPropertyDir()+"programs.xml"));
    }
    /**
     *  Constructor for the ProgramsXmlParser object
     *
     * @param  xmlFile                           Description of the Parameter
     * @exception  ParserConfigurationException  Description of the Exception
     * @exception  SAXException                  Description of the Exception
     * @exception  IOException                   Description of the Exception
     */
    public ProgramController(File xmlFile) throws ParserConfigurationException, SAXException, IOException
    {
	//        controller = aController;//, AlignmentController aController
        DOMParser parser = new DOMParser();
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.parse(new InputSource(new FileInputStream(xmlFile)));
        document = parser.getDocument();
        extractPrograms();
    }

    


    /**
     *  Description of the Method
     */
    protected void extractPrograms()
    {
        NodeList nl = document.getElementsByTagName("program");
        Program prog;
        for (int i = 0; i < nl.getLength(); i++)
        {
            prog = new Program(nl.item(i));
            programs.put(prog.getName(), prog);
        }
    }


    

    /**
     *  Gets the program attribute of the ProgramLoader object
     *
     * @param  key  Description of the Parameter
     * @return      The program value
     */
    public Program getProgram(String key)
    {
        return (Program)programs.get(key);
    }


   
    /**
     *  Description of the Method
     *
     * @param  spe  Description of the Parameter
     */
    public void error(SAXParseException spe)
    {
        System.out.println("Line: " + spe.getLineNumber() + ", Error: " + spe.getMessage());
    }


    /**
     *  Description of the Method
     *
     * @param  spe  Description of the Parameter
     */
    public void fatalError(SAXParseException spe)
    {
        System.out.println("Line: " + spe.getLineNumber() + ", Fatal error: " + spe.getMessage());
    }


    /**
     *  Description of the Method
     *
     * @param  spe  Description of the Parameter
     */
    public void warning(SAXParseException spe)
    {
        System.out.println("Line: " + spe.getLineNumber() + ", Warning: " + spe.getMessage());
    }


    /**
     *  Gets the programKeys attribute of the ProgramLoader object
     *
     * @return    The programKeys value
     */
    public Enumeration getProgramKeys()
    {
        return programs.keys();
    }
    
 
    public void selectProgram(String name, Hashtable checkBoxes)
    {
        if(getProgram(name) != null)
        {
        getProgram(name).setSelected(true);
        
        if(getProgram(name).getDepends() != null)
        {
          if(checkBoxes.get(getProgram(name).getDepends()) != null)
          {
            ((JCheckBox)checkBoxes.get(getProgram(name).getDepends())).setSelected(true);
          }
          selectProgram(getProgram(name).getDepends(), checkBoxes);
        }
        }
    }
    
    public boolean isProgramSelected(String name)
    {
        return getProgram(name).isSelected();
    }
    
    public void unselectProgram(String name, Hashtable checkBoxes)
    {
        getProgram(name).setSelected(false);
        Enumeration e = programs.keys();
        while(e.hasMoreElements())
        {
          String pName = (String)e.nextElement();
          if(isProgramSelected(pName) && getProgram(pName).getDepends().equals(name))
          {
            ((JCheckBox)checkBoxes.get(pName)).setSelected(false);
            unselectProgram(pName, checkBoxes);
          }
        }
    }
    
    public int getNumberOfPrograms()
    {
        return programs.size();
    }
    
    public void reset()
    {
    	Enumeration e = programs.keys();
        while(e.hasMoreElements())
        {
          String pName = (String)e.nextElement();
          Program currProgram =getProgram(pName); 
          if(isProgramSelected(pName) )
          {
            
        	  currProgram.setSelected(false);
        	  currProgram.reset();
          }
          Enumeration parameters = currProgram.getParameters();
          while(parameters.hasMoreElements()){
        	  Parameter param = (Parameter)parameters.nextElement();
        	  if(param.isSelected() && !param.isDefaultSelected()){
        		  param.setSelected(false);
        	  }
          }
        }
    }
}

