/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.gui.alignment;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import dk.kvl.gui.components.*;

public class SubalignmentSelector extends JDialog implements ActionListener
{
    private final JLabel nameLabel = new JLabel("Write a name:");
    private final JLabel seqLabel = new JLabel("Choose the sequences:");
    private final JLabel indexLabel = new JLabel("Write the start and end Index:");
    private JTextField nameField = new JTextField();
    private JTextField startField = new JTextField(5);
    private JTextField endField = new JTextField(5);
    private JList seqNames = null;
    private boolean done = false; 
    private boolean ok = false;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private ActionListener listener;
    
    private SubalignmentSelector(String[] selectedNames, String[] allNames, int start, int end, ActionListener listener)
    {
        getContentPane().setLayout(new BorderLayout());
        createNamePanel();
        createIntervalPanel();
        this.listener = listener;
        startField.setText(""+start);
        endField.setText(""+end);
        createSequencePanel(selectedNames,allNames);
        getContentPane().add(BorderLayout.CENTER, mainPanel);
        getContentPane().add(BorderLayout.CENTER, mainPanel);
        setSize(400,600);
        getContentPane().add(BorderLayout.SOUTH, new OkCancelPanel(this));
        setVisible(true);
    }
    
    public void createNamePanel()
    {
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BoxLayout(namePanel ,BoxLayout.Y_AXIS));
        namePanel.add(nameLabel);
        namePanel.add(nameField);
        mainPanel.add(BorderLayout.NORTH, namePanel);
    }
    
    public void createSequencePanel(String[] selectedNames, String[] allNames)
    {
        JPanel sequencePanel = new JPanel();
        sequencePanel.setLayout(new BoxLayout(sequencePanel ,BoxLayout.Y_AXIS));
        sequencePanel.add(seqLabel);
        seqNames = new JList(allNames);
        seqNames.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        for(int i = 0;i<selectedNames.length;i++)
        {
            for(int j = 0; j<allNames.length;j++)
            {
                if(selectedNames[i].equals(allNames[j]))
                {
                     seqNames.addSelectionInterval(j,j);
                     break;
                }
            }
        }
        JScrollPane nameScroll = new JScrollPane(seqNames);
        sequencePanel.add(nameScroll);
        mainPanel.add(BorderLayout.CENTER, sequencePanel);
    }
    
    public void createIntervalPanel()
    {
        JPanel intervalPanel = new JPanel();
        intervalPanel.setLayout(new BoxLayout(intervalPanel ,BoxLayout.Y_AXIS));
        intervalPanel.add(indexLabel);
        JPanel indexPanel = new JPanel(new FlowLayout());
        indexPanel.add(new JLabel("From: "));
        indexPanel.add(startField);
        indexPanel.add(new JLabel(" to: "));
        indexPanel.add(endField);
        intervalPanel.add(indexPanel);
        mainPanel.add(BorderLayout.SOUTH, intervalPanel);
        
    }
    
    public int getStart()
    {
        return Integer.parseInt(startField.getText());
    }
    
    public int getEnd()
    {
        try
        {
        int result = Integer.parseInt(endField.getText());
        return result;
        }
        catch(NumberFormatException nf)
        {
            JOptionPane.showMessageDialog(null, nf.getMessage());
            return -1;
        }
        
    }
    
    public String getName()
    {
        return nameField.getText(); 
    }
    
    public Vector getSelected()
    {
        Vector names = new Vector();
        for(int i = 0;i<seqNames.getSelectedValues().length;i++)
        {
            names.add((String)seqNames.getSelectedValues()[i]);
        }
        return names;
    }
    
    public static SubalignmentSelector showSubalignmentSelector(String[] selectedNames, String[] allNames, int start, int end, ActionListener listener)
    {
        SubalignmentSelector selector = new SubalignmentSelector(selectedNames, allNames, start,end,listener);
        
        return selector;
    }
    
    
    public void actionPerformed(ActionEvent ae)
    {
         if(ae.getActionCommand().equals("OK"))
         {
             if(nameField.getText().length()>1 && seqNames.getSelectedIndices().length > 0 )
             {
                 listener.actionPerformed(new ActionEvent(this, 1, "OK"));
                listener = null;
             }
             else
             {
                 JOptionPane.showMessageDialog(null, "Name and sequence selection needed!");
             }
         }
         else
         {
             listener = null;
             dispose();
         }
    }
    
    public boolean isOk()
    {
        return ok;
    }
    
    public boolean isDone()
    {
        return done;
    }
}

