/*
 *  SARSE, Semi-Automated RNA Sequence Editor.
 *  Copyright (C) 2004 Allan Lind-Thomsen
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dk.kvl.gui.alignment.table;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;
import java.awt.*;
import dk.kvl.gui.properties.*;
import dk.kvl.gui.alignment.AlignmentPanel;
import dk.kvl.controller.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    June 24, 2004
 */
public class AlignmentRenderer extends DefaultTableCellRenderer {
  private AlignmentProperties properties = null;
  private AlignmentPanel ap;
  //    private Cell lastCell; // Not used/ps?
  static int count;


  /**
   *  Constructor for the AlignmentRenderer object
   */
  protected AlignmentRenderer() {
    setOpaque(true);
    setVerticalAlignment(SwingConstants.CENTER);
    setHorizontalAlignment(SwingConstants.CENTER);
    if (properties == null) {
      setBorder(new EmptyBorder(1, 1, 1, 1));
    } else {
      try {
        setBorder(new AlignmentBorder(properties));
      } catch (Exception e) {
        setBorder(new EmptyBorder(1, 1, 1, 1));
      }
    }
  }


  /**
   *  Constructor for the AlignmentRenderer object
   *
   * @param  properties  Description of the Parameter
   * @param  ap          Description of the Parameter
   */
  public AlignmentRenderer(AlignmentProperties properties, AlignmentPanel ap) {
    this();
    this.properties = properties;
    this.ap = ap;
  }


  /**
   *  Gets the tableCellRendererComponent attribute of the AlignmentRenderer
   *  object
   *
   * @param  table       Description of the Parameter
   * @param  title       Description of the Parameter
   * @param  isSelected  Description of the Parameter
   * @param  hasFocus    Description of the Parameter
   * @param  row         Description of the Parameter
   * @param  column      Description of the Parameter
   * @return             The tableCellRendererComponent value
   */
  public Component getTableCellRendererComponent(JTable table, Object title, boolean isSelected, boolean hasFocus, int row, int column) {
    setForeground(properties.getTextColor());
    setFont(properties.getTableFont());
    setHorizontalTextPosition(SwingConstants.CENTER);
    String txt = (String) title;
    if (txt == null) {
      //this is the case when a cell is selected, this avoids the symptoms but dosn't solve the problem!
      txt = "" + table.getModel().getValueAt(row, column);
    }
    setText(txt);
    if (properties.isBaseColoringEnabled()) {
      baseColoring(txt, row);
    }

    if (properties.isColored()) {
      analysisColoring(table, row, column);
    } else {
      setBackground(properties.getBackground());
    }
    if (isSelected) {
      if (ap.isSplit()) {
        Color primary = properties.getPrimarySelectionColor();
        Color secondary = properties.getSecondarySelectionColor();
        JTable table2 = ap.getTable2();
        JTable table3 = ap.getTable3();
        if (ap.getOperationMode() == 1) {
          if (ap.getSelectionMode()) {
            if (table2.equals(table)) {
              setBackground(primary);
            }
          } else {
            if (table2.equals(table)) {
              setBackground(primary);
            } else {
              setBackground(secondary);
            }
          }
        } else {
          if (ap.getOperationMode() == 2) {
            if (ap.getSelectionMode()) {
              if (table2.equals(table)) {
                setBackground(primary);
              }
            } else {
              if (table2.equals(table)) {
                setBackground(secondary);
              } else {
                setBackground(primary);
              }
            }
          } else {
            if (ap.getSelectionMode()) {
              if (table2.equals(table)) {
                setBackground(primary);
              }
            } else {
              setBackground(primary);
            }
          }
        }
      } else {
        setBackground(properties.getPrimarySelectionColor());
      }
    }
    return this;
  }


  /**
   *  Description of the Method
   *
   * @param  txt  Description of the Parameter
   * @param  row  Description of the Parameter
   */
  public void baseColoring(String txt, int row) {
    
    if (ap.getController().getPairingmask() != null && row == 0) {
      setForeground(properties.getTextColor());
    } else if (txt.equals("a") || txt.equals("A")) {
      setForeground(properties.getAColor());
    } else if (txt.equals("g") || txt.equals("G")) {
      setForeground(properties.getGColor());
    } else if (txt.equals("c") || txt.equals("C")) {
      setForeground(properties.getCColor());
    } else if (txt.equals("u") || txt.equals("U") || txt.equals("t") || txt.equals("T")) {
      setForeground(properties.getUColor());
    } else if (txt.equals("-")) {
      setForeground(properties.getTextColor());
    } else {
      setForeground(properties.getTextColor());
    }
    setBackground(properties.getBackground());
  }


  /**
   *  Description of the Method
   *
   * @param  table   Description of the Parameter
   * @param  row     Description of the Parameter
   * @param  column  Description of the Parameter
   */
  protected void analysisColoring(JTable table, int row, int column) {
    AlignmentDataModel adm = (AlignmentDataModel) table.getModel();
    Color c = adm.getBackground(row, column);
    if (c.equals(Color.WHITE)) {
      setBackground(properties.getBackground());
    } else {
      setBackground(c);
    }
  }
}

