/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.gui.components;

import javax.swing.*;
import dk.kvl.gui.alignment.*;
import dk.kvl.gui.components.*;
import dk.kvl.gui.properties.*;
import java.awt.*;
import java.awt.event.*;
import dk.kvl.controller.*;
import dk.kvl.alignmenttools.*;
import java.util.*;
import dk.kvl.tools.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    February 12, 2004
 */
public class AnalyzeFrame extends JFrame implements ActionListener
{
    private final Alignment alignment;
    private ProgramController programs = null;
    private final AlignmentProperties properties;
    private ActionListener resultListener;
    private String projectName;
    private ProjectProperties pProperties; 
    /**
     *  Constructor for the AnalyzeFrame object
     *
     * @param  loader  Description of the Parameter
     */
    public AnalyzeFrame(AlignmentProperties props, ProjectProperties pProperties, Alignment align, ActionListener listener,String projectName) throws Exception
    {
        super("Programs");
        resultListener = listener;
        this.projectName = projectName;
        alignment = align;
        properties = props;
	this.pProperties = pProperties; 
	programs = properties.getProgramController();
	programs.reset();
//	try
//	    {
//			programs = new ProgramController();//props.getProgramController();
//		
//	    }
//	catch(Exception e)
//	    {
//		e.printStackTrace();
//	    }
	ProgramPanel programPanel = new ProgramPanel(props, programs);
	
        getContentPane().add(BorderLayout.CENTER, programPanel);
        getContentPane().add(BorderLayout.SOUTH, new OkCancelPanel(this));
	setLocation(50,50);
        setSize(700, 500);
        setVisible(true);
    }
    
    public void actionPerformed(ActionEvent ae)
    {
        if(ae.getActionCommand().equals("Cancel"))
        {
        	((AlignmentContainer)resultListener).setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        	dispose();
        }
        else
        {
            Vector selectedPrograms = new Vector();
            Enumeration e = programs.getProgramKeys();
            while(e.hasMoreElements())
            {
                Program p = programs.getProgram((String)e.nextElement());
                if(p.isSelected())
                {
                    selectedPrograms.add(p);
                }
            }
            if(selectedPrograms.size() > 0)
            {
            	Analyzer analyzer = new Analyzer(selectedPrograms, alignment, properties, pProperties, resultListener, projectName, System.currentTimeMillis()+"");
            }
            else
            {
            	JOptionPane.showMessageDialog(this,"No programs selected","WARNING",JOptionPane.WARNING_MESSAGE);
            	((AlignmentContainer)resultListener).setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
            }
            //((AlignmentContainer)resultListener).setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
        	resultListener = null;
            dispose();
            
        }
    }
    
    public void removeActionListener()
    {
        resultListener = null;
    }
    
    
    
}

