/**
 *		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dk.kvl.gui.components;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.*;
import javax.swing.tree.*;

import dk.kvl.tools.*;
import dk.kvl.controller.*;
import dk.kvl.gui.components.*;
import java.util.*;
import dk.kvl.gui.properties.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    February 10, 2004
 */
public class ProgramPanel extends JPanel implements TreeSelectionListener, ItemListener {
  private ProgramController programs = null;
  private JPanel programPanel = new JPanel(new CardLayout());
  private JTree programTree;
  private Hashtable checkBoxes = new Hashtable();
  private java.util.List rnadbtool = new ArrayList();
  private java.util.List pfold = new ArrayList();
  private java.util.List cluster = new ArrayList();
  private java.util.List allSorted = new ArrayList();
  private Hashtable packageNodes = new Hashtable();
  private Hashtable packagePanels = new Hashtable();
  private Hashtable programPanels = new Hashtable();

  /**
   *  Constructor for the ProgramPanel object
   *
   * @param  props     Description of the Parameter
   * @param  programs  Description of the Parameter
   */
  public ProgramPanel(AlignmentProperties props, ProgramController programs) {
    super(new BorderLayout());
    this.programs = programs;
    categorize();
    createProgramTree();
    createProgramPanels();
    createPackagePanels();
    createDefaultPanel();
    //createSelectProgramPanel();
    //((CardLayout) programPanel.getLayout()).show(programPanel, "programs");
    ((CardLayout) programPanel.getLayout()).show(programPanel, "default");
    //JScrollPane programScroll = new JScrollPane(programPanel, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    //programScroll.setWheelScrollingEnabled(true);
    //JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, new JScrollPane(programTree), programScroll);
    JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, new JScrollPane(programTree), programPanel);
    splitPane.setDividerLocation(150);
    //hack
    add(BorderLayout.CENTER, splitPane);
  }

  public void reset()
  {
	  Enumeration progs = programs.getProgramKeys();
	  while(progs.hasMoreElements())
	  {
		  String name = (String)progs.nextElement();
		  if(programs.isProgramSelected(name))
		  {
			  programs.unselectProgram(name,checkBoxes);
		  }
	  }
  }
  /**
   *  Description of the Method
   */
  public void createProgramPanels() {
    for (int i = 0; i < allSorted.size(); i++) {
      createProgramView((Program) allSorted.get(i));
    }
  }


  /**
   *  Description of the Method
   *
   * @param  prog  Description of the Parameter
   */
  public void createProgramView(Program prog) {
    Box panel = new Box(BoxLayout.Y_AXIS);
    //title+desscription
    JPanel top = new JPanel(new BorderLayout());
    top.setPreferredSize(new Dimension(500, 100));
    JPanel topTop = new JPanel(new BorderLayout());
    topTop.setPreferredSize(new Dimension(500, 50));
    JPanel topBottom = new JPanel(new BorderLayout());
    topBottom.setPreferredSize(new Dimension(500, 50));

    JLabel name = new JLabel("<html> &nbsp Program: " + prog.getName() + "</html>");
    //topTop.add(name, BorderLayout.NORTH);

    JLabel descr = new JLabel("<html> " + prog.getDescription() + "</html>");
    descr.setFont(descr.getFont().deriveFont(Font.PLAIN));
    //topTop.add(descr, BorderLayout.CENTER);

    //top.add(topTop, BorderLayout.NORTH);

    //input+output
    JLabel input = new JLabel("<html><br>&nbsp Input format(s): " + prog.getInputTypes() + "</html>");
    topBottom.add(input, BorderLayout.NORTH);

    JLabel output = new JLabel("<html>&nbsp Output format(s): " + prog.getOutputTypes() + " <br></html>");
    topBottom.add(output, BorderLayout.CENTER);

    top.add(topBottom, BorderLayout.CENTER);

    //panel.add(top, BorderLayout.NORTH);

    //parameters
    Enumeration params = prog.getParameters();

    JPanel cBoxPanel = null;
    JPanel parameters = null;
    JPanel parametersTop = null;
    JPanel parametersBottom = null;
    Box bottom = new Box(BoxLayout.Y_AXIS);
    JLabel description = null;
    ProgramCheckBox cBox = null;
    int p = 0;
    int selCounter = 0;
    while (params.hasMoreElements()) {
      final Parameter param = (Parameter) params.nextElement();
      p++;
      cBox = new ProgramCheckBox(prog.getName(),param.getName());
      cBoxPanel = new JPanel(new BorderLayout());
      if (prog.isParameterSelected(param.getName())) {
        cBox.setSelected(true);
      }
      cBox.addItemListener(this);
      cBoxPanel.add(cBox);

      parameters = new JPanel(new BorderLayout());
      parametersTop = new JPanel(new FlowLayout(FlowLayout.LEFT));
      parametersBottom = new JPanel(new FlowLayout(FlowLayout.LEFT));

      description = new JLabel("<html>" + param.getDescription() + "</html>");
      description.setFont(description.getFont().deriveFont(Font.PLAIN));
      parametersTop.add(description);
      parameters.add(parametersTop, BorderLayout.NORTH);

      if (param.isInputRequired()) {
        JLabel pLabel = new JLabel("Parameter: ");
        pLabel.setFont(pLabel.getFont().deriveFont(Font.PLAIN));
        parametersBottom.add(pLabel);

        final JTextField tf = new JTextField(param.getDefaultValue(), 20);
        tf.addFocusListener(
          new FocusAdapter() {
            public void focusLost(FocusEvent fe) {
              param.setDefaultValue(tf.getText());
            }
          });

        parametersBottom.add(tf);
        parameters.add(parametersBottom, BorderLayout.CENTER);

        JPanel bottomParam = new JPanel(new BorderLayout());
        bottomParam.add(cBoxPanel, BorderLayout.NORTH);
        bottomParam.add(parameters, BorderLayout.CENTER);

        bottom.add(bottomParam);

      } else {
        JPanel bottomParam = new JPanel(new BorderLayout());
        bottomParam.add(cBoxPanel, BorderLayout.NORTH);
        bottomParam.add(parameters, BorderLayout.CENTER);

        bottom.add(bottomParam);
      }
      panel.add(bottom, BorderLayout.CENTER);
    }
    //JScrollPane paramScroll = new JScrollPane(panel, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    //panel.add(BorderLayout.CENTER, paramScroll);*/
    //
    panel.add(Box.createVerticalGlue());
    panel.setBorder(new EmptyBorder(0,30,0,0));
    //programPanel.add(prog.getName(), panel);
    if(p>0)
    {
    	programPanels.put(prog.getName(), panel);
    }
  }


  /**
   *  Description of the Method
   */
  public void createProgramTree() {
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("Program Packages");
    //DefaultMutableTreeNode analyzers = new DefaultMutableTreeNode("Analyzers");
    //DefaultMutableTreeNode filters = new DefaultMutableTreeNode("Filters");
    programTree = new JTree(root);
    
    
    programTree.setSize(200, 500);
    //root.add(analyzers);
    //root.add(filters);
    programTree.addTreeSelectionListener(this);
    //
    //Hashtable packageNodes = new Hashtable();
    ProgramNode progNode;
    DefaultMutableTreeNode packageNode;
    for (int i = 0; i < allSorted.size(); i++) {
      Program prog = (Program) allSorted.get(i);
      String pack = prog.getPackage();
      if(packageNodes.get(pack) == null)
      {
        packageNode = new DefaultMutableTreeNode(pack);
        packageNodes.put(pack, packageNode);
        root.add(packageNode);
      }
      else
      {
        packageNode = (DefaultMutableTreeNode)packageNodes.get(pack);
      }
      //progNode = new ProgramNode(prog.getName());
      //packageNode.add(progNode);
    }
    programTree.expandRow(0);
  }


  /**
   *  
   */
  public void categorize() {
    Enumeration e = programs.getProgramKeys();

    while (e.hasMoreElements()) {
      Program prog = programs.getProgram((String) e.nextElement());
      if (prog.getPackage().equals("rnadbtool")) {
        rnadbtool.add(prog);
      } else {
        if (prog.getPackage().equals("pfold")) {
          pfold.add(prog);
        } else {
          cluster.add(prog);
        }
      }
    }
    Collections.sort(pfold);
    Collections.sort(rnadbtool);
    Collections.sort(cluster);
    allSorted.addAll(rnadbtool);
    allSorted.addAll(pfold);
    allSorted.addAll(cluster);
  }


  /**
   *  Description of the Method
   *
   * @param  e  Description of the Parameter
   */
  public void valueChanged(TreeSelectionEvent e) {
    DefaultMutableTreeNode node = (DefaultMutableTreeNode) programTree.getLastSelectedPathComponent();

    if (node != null && ((String) node.getUserObject()).equals("Program Packages")) {
      ((CardLayout) programPanel.getLayout()).show(programPanel, "default");
      
    } else if (node != null && node.getClass().getName().equals("dk.kvl.gui.components.ProgramNode")) {
      ((CardLayout) programPanel.getLayout()).show(programPanel, (String) node.getUserObject());
      
    }
    else if (node != null)
    {
      //only packagenodes left
      
      ((CardLayout) programPanel.getLayout()).next(programPanel);
      ((CardLayout) programPanel.getLayout()).show(programPanel, (String) node.getUserObject());
    }
      
  }


  /**
   *  Description of the Method
   *
   * @param  ie  Description of the Parameter
   */
  public void itemStateChanged(ItemEvent ie) {
  	JCheckBox changed = (JCheckBox) ie.getItem();
  	String selected;
  	if(ie.getItem() instanceof ProgramCheckBox)
    {    	
  		selected = ((ProgramCheckBox)changed).getProgram();
  		Program prog = programs.getProgram(selected);
  	    if (!prog.isSelected()) {
  	    	changed.setSelected(true);
  	    	programs.selectProgram(changed.getText(), checkBoxes);
  	    }
  	  if (changed.isSelected()) {
  	    	prog.selectParameter(changed.getText());
  	      } else {
  	        prog.unselectParameter(changed.getText());
  	      }
    }
    else
    {
    	selected = changed.getText();
    	Program prog = programs.getProgram(selected);
    	if (changed.isSelected()) {
            programs.selectProgram(changed.getText(), checkBoxes);
          } else {
            programs.unselectProgram(changed.getText(), checkBoxes);
          }  
    }
    
  }


  /**
   *  Description of the Method
   */
  public void createSelectProgramPanel() {
    JPanel selectPrograms = new JPanel(new BorderLayout());
    JLabel clust = new JLabel("<html>&nbsp CLUSTER.TCSH </html>");
    JLabel rnadb = new JLabel("<html>&nbsp RNADBTOOL <br> &nbsp Select one or more programs to run.</html>");

    Box programSelectPanel = new Box(BoxLayout.Y_AXIS);
    Enumeration e = programs.getProgramKeys();
    JPanel cBoxPanel;
    JLabel description = null;
    JCheckBox cBox = null;
    Program prog = null;
    
    cBoxPanel = new JPanel(new BorderLayout());
    cBoxPanel.add(BorderLayout.WEST, rnadb);
    
    programSelectPanel.add(cBoxPanel);
    for (int i = 0; i < rnadbtool.size(); i++) {
      prog = (Program) rnadbtool.get(i);
      if (prog != null && prog.getType().equals("analyzer")) {
        cBox = new JCheckBox(prog.getName());
        checkBoxes.put(prog.getName(), cBox);
        cBox.addItemListener(this);
        if (programs.isProgramSelected(prog.getName())) {
          cBox.setSelected(true);
        }
        description = new JLabel("<html> " + prog.getDescription() + "</html>");
        Font f = description.getFont();
        description.setFont(f.deriveFont(Font.PLAIN));
        cBoxPanel = new JPanel(new BorderLayout());
        JLabel space = new JLabel();
        space.setText("<html>&nbsp &nbsp &nbsp &nbsp &nbsp</html>");
        JPanel descPanel = new JPanel(new BorderLayout());
        descPanel.add(space, BorderLayout.WEST);
        descPanel.add(description, BorderLayout.CENTER);
        cBoxPanel.add(BorderLayout.NORTH, cBox);
        cBoxPanel.add(BorderLayout.CENTER, descPanel);
        programSelectPanel.add(cBoxPanel);
      }
    }
    JLabel pfoldLabel = new JLabel("<html><br> &nbsp PFOLD <br> &nbsp Always select findphyl and scfg, then add on further programs to run. </html>");
    cBoxPanel = new JPanel(new BorderLayout());
    cBoxPanel.add(BorderLayout.WEST, pfoldLabel);
    programSelectPanel.add(cBoxPanel);
    for (int i = 0; i < pfold.size(); i++) {
      prog = (Program) pfold.get(i);
      if (prog != null && prog.getType().equals("analyzer")) {
        cBox = new JCheckBox(prog.getName());
        checkBoxes.put(prog.getName(), cBox);
        //cBox.setLocation(0, 0);
        cBox.addItemListener(this);
        if (programs.isProgramSelected(prog.getName())) {
          cBox.setSelected(true);
        }
        description = new JLabel("<html> " + prog.getDescription() + "</html>");
        Font f = description.getFont();
        description.setFont(f.deriveFont(Font.PLAIN));
        cBoxPanel = new JPanel(new BorderLayout());
        JLabel space = new JLabel();
        space.setText("<html>&nbsp &nbsp &nbsp &nbsp &nbsp</html>");
        JPanel descPanel = new JPanel(new BorderLayout());
        descPanel.add(space, BorderLayout.WEST);
        descPanel.add(description, BorderLayout.CENTER);
        cBoxPanel.add(BorderLayout.NORTH, cBox);
        cBoxPanel.add(BorderLayout.CENTER, descPanel);
        programSelectPanel.add(cBoxPanel);
      }
    }
    
    cBoxPanel = new JPanel(new BorderLayout());
    cBoxPanel.add(BorderLayout.WEST, clust);
    programSelectPanel.add(cBoxPanel);
      for (int i = 0; i < cluster.size(); i++) {
      prog = (Program) cluster.get(i);
      if (prog != null && prog.getType().equals("analyzer")) {
        cBox = new JCheckBox(prog.getName());
        checkBoxes.put(prog.getName(), cBox);
        cBox.addItemListener(this);
        if (programs.isProgramSelected(prog.getName())) {
          cBox.setSelected(true);
        }
        description = new JLabel("<html> " + prog.getDescription() + "</html>");
        Font f = description.getFont();
        description.setFont(f.deriveFont(Font.PLAIN));
        JLabel space = new JLabel();
        space.setText("<html>&nbsp &nbsp &nbsp &nbsp &nbsp</html>");
        JPanel descPanel = new JPanel(new BorderLayout());
        descPanel.add(space, BorderLayout.WEST);
        descPanel.add(description, BorderLayout.CENTER);
        cBoxPanel = new JPanel(new BorderLayout());
        cBoxPanel.add(BorderLayout.NORTH, cBox);
        cBoxPanel.add(BorderLayout.CENTER, descPanel);
        programSelectPanel.add(cBoxPanel);
      }
    }
    selectPrograms.add(BorderLayout.CENTER, programSelectPanel);
    programPanel.add("programs", selectPrograms);
  }
  
  public void createPackagePanels()
  {
    CardLayout cards = (CardLayout)programPanel.getLayout();
    JPanel packagePanel;
    JPanel cBoxPanel;
    JTextArea description;
    JCheckBox cBox = null;
    Box programSelectPanel;
    for(int i = 0; i< allSorted.size();i++)
    {
      Program prog = (Program)allSorted.get(i);
      if (prog != null && prog.getType().equals("analyzer"))
      {
      if(packagePanels.get(prog.getPackage()) == null)
      {
        packagePanel = new JPanel(new BorderLayout());
        JLabel title = new JLabel("<html><h2>&nbsp "+prog.getPackage()+
            " </h2>Select the programs you want to run, then click OK to run them. </html>");
        packagePanel.add(BorderLayout.NORTH, title);
        programSelectPanel = new Box(BoxLayout.Y_AXIS);
        //programSelectPanel = new JPanel(new GridBagLayout());
        //programSelectPanel = new JPanel();
        JScrollPane progPane= new JScrollPane(programSelectPanel);
        progPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        
        //packagePanel.add(BorderLayout.CENTER, programSelectPanel);
        packagePanel.add(BorderLayout.CENTER, progPane);
        //cards.addLayoutComponent(packagePanel, prog.getPackage());
        
        programPanel.add(prog.getPackage(), packagePanel);
        packagePanels.put(prog.getPackage(), programSelectPanel);
      }
      else
      {
        programSelectPanel = (Box)packagePanels.get(prog.getPackage());
        //((GridLayout)programSelectPanel.getLayout()).setRows(((GridLayout)programSelectPanel.getLayout()).getRows()+1);
      }
        cBox = new JCheckBox(prog.getName());
        checkBoxes.put(prog.getName(), cBox);
        cBox.addItemListener(this);
        if (programs.isProgramSelected(prog.getName())) {
          cBox.setSelected(true);
        }
        description = new JTextArea(prog.getDescription());
       
        description.setEditable(false);
        description.setLineWrap(true);
        description.setBackground(cBox.getBackground());
        description.setWrapStyleWord(true);
        Font f = description.getFont();
        description.setFont(f.deriveFont(Font.PLAIN));
        cBoxPanel = new JPanel(new GridBagLayout());
        //((FlowLayout)cBoxPanel.getLayout()).setAlignment(FlowLayout.LEFT);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx =0;
        constraints.gridy =0;
        constraints.anchor = GridBagConstraints.FIRST_LINE_START;
        constraints.fill = GridBagConstraints.HORIZONTAL;
        cBoxPanel.add(cBox,constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth=2;
        constraints.weightx = 0.7;
        cBoxPanel.add(description,constraints);
        constraints.gridwidth=1;
        constraints.gridy =0;
        constraints.gridx =1;
        cBoxPanel.add(optionPanel(prog.getName(),cBoxPanel),constraints);
        //constraints.insets = new Insets(0,20,0,0);
        //constraints.anchor = GridBagConstraints.WEST;
        //cBoxPanel.add(optionPanel(prog.getName()),constraints);
        //cBoxPanel.add((Box)programPanels.get(prog.getName()),constraints);
        cBoxPanel.setBorder(new EmptyBorder(0,0,10,0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.anchor = GridBagConstraints.FIRST_LINE_START;
        constraints.fill = GridBagConstraints.HORIZONTAL;
        
        constraints.anchor = GridBagConstraints.WEST;
        constraints.gridy = programSelectPanel.getComponentCount();
        programSelectPanel.add(cBoxPanel);
    }
    }
  }
  
  public void createDefaultPanel()
  {
    JPanel defaultPanel = new JPanel(new BorderLayout());
    String text = "<html>Select a Package on the left to se its content<br>" +
    		"<p>Expand the package-folder to be able to select parameters for individual programs.</p> </html>";
    JLabel textLabel = new JLabel(text);
    defaultPanel.add(BorderLayout.NORTH,textLabel);
    programPanel.add(defaultPanel,"default");
  }
  
  protected Box optionPanel(String programname,JPanel panel)
  {
    final String name = programname; 
    final JPanel p = panel;
    final Box optionPanel = new Box(BoxLayout.Y_AXIS);
    optionPanel.setBorder(new EmptyBorder(2,0,15,0));
    if(programPanels.get(name) != null)
    {
    final JButton optionButton = new JButton("Options");
    optionButton.addActionListener(new ActionListener(){

      public void actionPerformed(ActionEvent e) {
      	if(e.getActionCommand().equals("Options"))
      	{
      		optionButton.setText("Hide options");
      		GridBagConstraints c = new GridBagConstraints();
      		c.gridx=0;
      		c.gridy=2;
      		c.anchor = GridBagConstraints.LINE_START;
      		c.gridwidth=2;
      		p.add((Box)programPanels.get(name),c);
      		validate();
      	}
      	else
      	{
      		optionButton.setText("Options");
      		p.remove((Box)programPanels.get(name));
      		//optionPanel.remove((Box)programPanels.get(name));
      	}
      }
    });
    optionButton.setBorder(new LineBorder(Color.BLACK,1,true));
    optionPanel.add(optionButton);
    }
    JPanel options = new JPanel(new BorderLayout());
    //options.add((Box)programPanels.get(programname));
    return optionPanel;
  }
}

