/*
 *  SARSE, Semi-Automated RNA Sequence Editor.
 *  Copyright (C) 2004 Allan Lind-Thomsen
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package dk.kvl.gui.components;

import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.event.*;
import dk.kvl.gui.alignment.table.*;
import dk.kvl.gui.alignment.*;
import java.util.*;
import dk.kvl.gui.properties.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    February 26, 2004
 */
public class TwoTablePanel extends JPanel implements ChangeListener, ListSelectionListener
{
    private JScrollPane mainScroll = null;
    private JScrollPane nameScroll = null;
    private AlignmentTable mainTable = null;
    private TitleTable nameTable = null;
    private Vector changeListeners = new Vector();
    private boolean traceEnabled = true;
    private JSplitPane split = null;
    private AlignmentProperties properties = null;


    /**
     *  Constructor for the TwoTablePanel object
     *
     * @param  nameTable      Description of the Parameter
     * @param  mainTable      Description of the Parameter
     * @param  prop           Description of the Parameter
     * @exception  Exception  Description of the Exception
     */
    public TwoTablePanel(TitleTable nameTable, AlignmentTable mainTable, AlignmentProperties prop) throws Exception
    {
        super(new BorderLayout());
        setDoubleBuffered(true);
        properties = prop;
        if (nameTable.getRowCount() != nameTable.getRowCount())
        {
            throw new Exception("The number of rows must be equal");
        }
        else if (nameTable.getColumnCount() != 1)
        {
            throw new Exception("The nameTable may only contain one column");
        }
        this.mainTable = mainTable;
        this.nameTable = nameTable;
        nameTable.setFont(properties.getTableFont());
        mainScroll = new JScrollPane(mainTable);
        mainScroll.setDoubleBuffered(true);
        mainScroll.getViewport().addChangeListener(this);
        nameScroll = new JScrollPane(nameTable, JScrollPane.VERTICAL_SCROLLBAR_NEVER, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        //
        //nameTable.setRowSelectionAllowed(false);
        //mainTable.setRowSelectionAllowed(false);
        //
        //mainTable.setColumnSelectionAllowed(false);
        //nameTable.setColumnSelectionAllowed(false);
        //
        mainTable.setCellSelectionEnabled(true);
        nameTable.setCellSelectionEnabled(true);
        //
        mainTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        nameTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        //
        updateGrid();
        //
//        TableColumn tc = null;
        //for (int i = 0; i < mainTable.getColumnModel().getColumnCount(); i++)
        //{
          //  tc = mainTable.getColumnModel().getColumn(i);
//            tc.setPreferredWidth(mainTable.getPreferredCellWidth());
  //          tc.setMinWidth(mainTable.getMinCellWidth());
    //    }
        
        //System.out.println("Tablewidth:"+nameTable.getWidth());
        //System.out.println("Columnwidth:"+nameTable.getColumnModel().getColumn(0).getWidth());
        //
        split = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, nameScroll, mainScroll);
        split.setDividerLocation(mainTable.getColumnModel().getColumn(0).getWidth());
        add(split, BorderLayout.CENTER);
        updateCellSize();
    }


    /**
     *  Sets the dividerLocation attribute of the TwoTablePanel object
     *
     * @param  pos  The new dividerLocation value
     */
    public void setDividerLocation(double pos)
    {
        split.setDividerLocation(pos);
    }


    /**
     *  Events concerning movement of the viewport/scrollbars
     *
     * @param  ce  Description of the Parameter
     */
    public void stateChanged(ChangeEvent ce)
    {
        if (ce.getSource() instanceof java.lang.Integer)
        {
            int y = ((Integer)ce.getSource()).intValue();
            int x = (int)nameScroll.getViewport().getViewPosition().getX();
            nameScroll.getViewport().setViewPosition(new Point(x, y));
            x = (int)mainScroll.getViewport().getViewPosition().getX();
            mainScroll.getViewport().setViewPosition(new Point(x, y));
        }
        else
        {
            int y = (int)mainScroll.getViewport().getViewPosition().getY();
            int x = (int)nameScroll.getViewport().getViewPosition().getX();
            nameScroll.getViewport().setViewPosition(new Point(x, y));
        }
    }


    /**
     *  Description of the Method
     *
     * @param  column  Description of the Parameter
     * @param  row     Description of the Parameter
     */
    public void centerTable(int column, int row)
    {
        int posY = row;
        int posX;
        int compHeight = (int)mainTable.getSize().getHeight();
        int compWidth = (int)mainTable.getSize().getWidth();
        Dimension viewDim = mainScroll.getViewport().getExtentSize();
           int hStep = compWidth / mainTable.getColumnCount();
            posX = column * hStep - (int)viewDim.getWidth()/2;
        if (posX < 0)
        {
            posX = 0;
        }
        if (posX > compWidth - viewDim.width)
        {
            posX = compWidth - viewDim.width;
        }
        //if(posX != 0)
        //{
        mainScroll.getViewport().setViewPosition(new Point(posX, posY));
        //}
    }

    /**
     *  Adds a feature to the ChangeListener attribute of the TwoTablePanel
     *  object
     *
     * @param  listener  The feature to be added to the ChangeListener attribute
     */
    /*public void addChangeListener(ChangeListener listener)
    {
	System.out.println("der addes changelistener i ttpanel");
        changeListeners.add(listener);
    }*/


    /**
     *  Description of the Method
     *
     * @param  listener  Description of the Parameter
     */
    public void removeChangeListener(ChangeListener listener)
    {
        changeListeners.remove(listener);
    }


    /**
     *  Sets the traceEnabled attribute of the TwoTablePanel object
     *
     * @param  value  The new traceEnabled value
     */
    public void setTraceEnabled(boolean value)
    {
        traceEnabled = value;
        if (traceEnabled)
        {
            fireStateChangedEvent((int)mainScroll.getViewport().getViewPosition().getY());
        }
    }


    /**
     *  Gets the traceEnabled attribute of the TwoTablePanel object
     *
     * @return    The traceEnabled value
     */
    public boolean isTraceEnabled()
    {
        return traceEnabled;
    }


    /**
     *  Description of the Method
     *
     * @param  y  Description of the Parameter
     */
    public void fireStateChangedEvent(int y)
    {
        ChangeEvent ce = new ChangeEvent(new Integer(y));
	stateChanged(ce);
        for (int i = 0; i < changeListeners.size(); i++)
        {
            ((ChangeListener)changeListeners.get(i)).stateChanged(ce);
        }
    }


    /**
     *  Adds a feature to the ListSelectionListener attribute of the
     *  TwoTablePanel object
     *
     * @param  listener  The feature to be added to the ListSelectionListener
     *      attribute
     */
    public void addListSelectionListener(ListSelectionListener listener)
    {
        //mainTable.getSelectionModel().addListSelectionListener(listener);
        mainTable.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }


    /**
     *  Description of the Method
     *
     * @param  listener  Description of the Parameter
     */
    public void removeListSelectionListener(ListSelectionListener listener)
    {
        //mainTable.getSelectionModel().removeListSelectionListener(listener);
        mainTable.getColumnModel().getSelectionModel().removeListSelectionListener(listener);
    }


    /**
     *  Description of the Method
     *
     * @param  lse  Description of the Parameter
     */
    public void valueChanged(ListSelectionEvent lse)
    {

    }


    /**
     *  Gets the viewport attribute of the TwoTablePanel object
     *
     * @return    The viewport value
     */
    public JViewport getViewport()
    {
        return mainScroll.getViewport();
    }


    /**
     *  Description of the Method
     */
    public void updateCellSize()
    {
        int cellHeight = mainTable.getPreferredCellHeight();
        int cellWidth = mainTable.getPreferredCellWidth();
        mainTable.setRowHeight(cellHeight);
        nameTable.setRowHeight(cellHeight); 
        int padding = 5; //if there are problems showing all the name of a sequence this value may have to be adjusted
        int nameTableWidth = nameTable.getMaximumWidth()+2*padding;
        nameTable.getTableHeader().setSize(new Dimension(nameTableWidth, (2 * cellHeight)));
        nameTable.getColumnModel().getColumn(0).setPreferredWidth(nameTableWidth);
        mainTable.getTableHeader().setSize(new Dimension((int)mainTable.getTableHeader().getSize().getWidth(), (2 * cellHeight)));
        for (int i = 0; i < mainTable.getColumnCount(); i++)
        {
            mainTable.getColumnModel().getColumn(i).setPreferredWidth(cellWidth);
            mainTable.getColumnModel().getColumn(i).setMinWidth(cellWidth);
        }
    }


    /**
     *  Description of the Method
     */
    public void updateGrid()
    {
        mainTable.setShowGrid(properties.isGrid());
        nameTable.setShowGrid(properties.isGrid());
    }
    
    public void verticalCenter(int column, int row)
    {
        int posY;
        int posX = column;
        int compHeight = (int)mainTable.getSize().getHeight();
        int compWidth = (int)mainTable.getSize().getWidth();
        
        Dimension viewDim = mainScroll.getViewport().getExtentSize();
        int vStep = compHeight / mainTable.getRowCount();
        posY = row * vStep - (int)viewDim.getHeight()/2;
        
        if (posY < 0)
        {
            posY = 0;
        }
        if (posY > compHeight - viewDim.height)
        {
            posY = compHeight - viewDim.height;
        }
        mainScroll.getViewport().setViewPosition(new Point(posX, posY));
        
    }
    
    public void centerCell(int column, int row)
    {
        int posY = row;
        
        int posX = column;
        int compHeight = (int)mainTable.getSize().getHeight();
        int compWidth = (int)mainTable.getSize().getWidth();
        Dimension viewDim = mainScroll.getViewport().getExtentSize();
        int vStep = compHeight / mainTable.getRowCount();
        int hStep = compWidth / mainTable.getColumnCount();
        posY = row * vStep - (int)viewDim.getHeight()/2;
        posX = column * hStep - (int)viewDim.getWidth()/2;
        //System.out.println("Component height="+compHeight+", Viewport height="+viewDim.getHeight());
        if (posY > compHeight - viewDim.height)
        {
            posY = compHeight - viewDim.height;
        }
        if (posX > compWidth - viewDim.width)
        {
            posX = compWidth - viewDim.width;
        }
        //System.out.println("x="+posX+", y="+posY);
        if (posY < 0||compHeight<=viewDim.getHeight())
        {
        	posY = 0;
        }
        if (posX < 0 ||compWidth<=viewDim.getWidth())
        {
            posX = 0;
        }
        mainScroll.getViewport().setViewPosition(new Point(posX, posY));
    }
}


