/*
 *  SARSE, Semi-Automated RNA Sequence Editor. Copyright (C) 2004 Allan
 *  Lind-Thomsen This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version. This program is distributed in the hope that it
 *  will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 *  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *  Public License for more details. You should have received a copy of the GNU
 *  General Public License along with this program; if not, write to the Free
 *  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 *  02111-1307, USA.
 */
package dk.kvl.gui.properties;

import java.util.*;
import java.awt.*;
import dk.kvl.controller.*;
import java.io.*;
import javax.swing.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    January 20, 2004
 */

public class AlignmentProperties extends Properties implements Serializable {
  private Font tableFont;
  private Color background = new Color(255, 255, 204);
  private Color textColor = Color.BLACK;
  private Color sequenceColor = Color.BLACK;
  private Color gapColor = Color.BLACK;
  private Color uColor = Color.BLUE;
  private Color aColor = Color.RED;
  private Color gColor = new Color(255, 153, 0);
  private Color cColor = Color.GREEN;
  private Color primarySelectionColor = new Color(110, 176, 241);
  private Color secondarySelectionColor = new Color(110, 176, 241);//Color.GRAY;
  private String lastPath;
  private transient ProgramController programController;
	
  //
  private boolean baseColoring = false;
  //
  private boolean colored = true;
  private static String homeDir;
  private static String projectDir;
  private boolean grid = false;


  /**
   *  Constructor for the AlignmentProperties object
   *
   * @exception  Exception  Description of the Exception
   */
  public AlignmentProperties() throws Exception {
	  programController = new ProgramController();
	  try {
      setFontName("verdana");
      setFontSize(10);
    } catch (Exception e) {
      JOptionPane.showMessageDialog(null, "Error creating tablefont");
      e.printStackTrace();
    }
  }


  /**
   *  Gets the lastPath attribute of the AlignmentProperties object
   *
   * @return    The lastPath value
   */
  public String getLastPath() {
    return getProperty("lastpath");
  }


  /**
   *  Sets the lastPath attribute of the AlignmentProperties object
   *
   * @param  path  The new lastPath value
   */
  public void setLastPath(String path) {
    setProperty("lastpath", path);
    //lastPath = path;
  }


  /**
   *  Sets the aColor attribute of the AlignmentProperties object
   *
   * @param  newColor  The new aColor value
   */
  public void setAColor(Color newColor) {
    aColor = newColor;
  }


  /**
   *  Sets the primarySelectionColor attribute of the AlignmentProperties object
   *
   * @param  newColor  The new primarySelectionColor value
   */
  public void setPrimarySelectionColor(Color newColor) {
    primarySelectionColor = newColor;
  }


  /**
   *  Sets the secondarySelectionColor attribute of the AlignmentProperties object
   *
   * @param  newColor  The new secondarySelectionColor value
   */
  public void setSecondarySelectionColor(Color newColor) {
    secondarySelectionColor = newColor;
  }


  /**
   *  Sets the uColor attribute of the AlignmentProperties object
   *
   * @param  newColor  The new uColor value
   */
  public void setUColor(Color newColor) {
    uColor = newColor;
  }


  /**
   *  Sets the gColor attribute of the AlignmentProperties object
   *
   * @param  newColor  The new gColor value
   */
  public void setGColor(Color newColor) {
    gColor = newColor;
  }


  /**
   *  Sets the sequenceColor attribute of the AlignmentProperties object
   *
   * @param  newColor  The new sequenceColor value
   */
  public void setSequenceColor(Color newColor) {
    sequenceColor = newColor;
  }


  /**
   *  Sets the cColor attribute of the AlignmentProperties object
   *
   * @param  newColor  The new cColor value
   */
  public void setCColor(Color newColor) {
    cColor = newColor;
  }


  /**
   *  Gets the aColor attribute of the AlignmentProperties object
   *
   * @return    The aColor value
   */
  public Color getAColor() {
    return aColor;
  }


  /**
   *  Gets the primarySelectionColor attribute of the AlignmentProperties object
   *
   * @return    The primarySelectionColor value
   */
  public Color getPrimarySelectionColor() {
    return primarySelectionColor;
  }


  /**
   *  Gets the secondarySelectionColor attribute of the AlignmentProperties object
   *
   * @return    The secondarySelectionColor value
   */
  public Color getSecondarySelectionColor() {
    return secondarySelectionColor;
  }


  /**
   *  Gets the uColor attribute of the AlignmentProperties object
   *
   * @return    The uColor value
   */
  public Color getUColor() {
    return uColor;
  }


  /**
   *  Gets the gColor attribute of the AlignmentProperties object
   *
   * @return    The gColor value
   */
  public Color getGColor() {
    return gColor;
  }


  /**
   *  Gets the cColor attribute of the AlignmentProperties object
   *
   * @return    The cColor value
   */
  public Color getCColor() {
    return cColor;
  }


  /**
   *  Gets the tableFont attribute of the AlignmentProperties object
   *
   * @return    The tableFont value
   */
  public Font getTableFont() {
    return tableFont;
  }


  /**
   *  Sets the tableFont attribute of the AlignmentProperties object
   *
   * @param  newFont  The new tableFont value
   */
  public void setTableFont(Font newFont) {
    tableFont = newFont;
  }


  /**
   *  Gets the baseColoringEnabled attribute of the AlignmentProperties object
   *
   * @return    The baseColoringEnabled value
   */
  public boolean isBaseColoringEnabled() {
    return baseColoring;
  }


  /**
   *  Sets the baseColoring attribute of the AlignmentProperties object
   *
   * @param  enabled  The new baseColoring value
   */
  public void setBaseColoring(boolean enabled) {
    baseColoring = enabled;
  }


  /**
   *  Gets the gapColor attribute of the AlignmentProperties object
   *
   * @return    The gapColor value
   */
  public Color getGapColor() {
    return gapColor;
  }


  /**
   *  Gets the sequenceColor attribute of the AlignmentProperties object
   *
   * @return    The sequenceColor value
   */
  public Color getSequenceColor() {
    return sequenceColor;
  }


  /**
   *  Description of the Method
   *
   * @return    Description of the Return Value
   */
  public boolean createMainViewFromBeginning() {
    return true;
  }


  /**
   *  Gets the projectDir attribute of the AlignmentProperties class
   *
   * @return    The projectDir value
   */
  public static String getProjectDir() {
    //return homeDir + "/projects";
    return projectDir;
  }


  /**
   *  Gets the logDir attribute of the AlignmentProperties class
   *
   * @return    The logDir value
   */
  public static String getLogDir() {
    File f = new File(projectDir + "/log/");
    if(!f.exists())
    {
      f.mkdirs();
    }
    return projectDir + "/log";
  }


  /**
   *  Gets the tmpDir attribute of the AlignmentProperties class
   *
   * @return    The tmpDir value
   */
  public static String getTmpDir() {
    File f = new File(projectDir + "/tmp/");
    if(!f.exists())
    {
      f.mkdirs();
    }
    return projectDir + "/tmp/";
  }


  /**
   *  Gets the homeDir attribute of the AlignmentProperties class
   *
   * @return    The homeDir value
   */
  public static String getHomeDir() {
    return homeDir;
  }


  /**
   *  Gets the colored attribute of the AlignmentProperties object
   *
   * @return    The colored value
   */
  public boolean isColored() {
    return colored;
  }


  /**
   *  Sets the homeDir attribute of the AlignmentProperties class
   *
   * @param  home  The new homeDir value
   */
  public static void setHomeDir(String home) {
    homeDir = home;
  }


  /**
   *  Gets the propertyDir attribute of the AlignmentProperties class
   *
   * @return    The propertyDir value
   */
  public static String getPropertyDir() {
    return homeDir + "/properties/";
  }


  /**
   *  Gets the iconDir attribute of the AlignmentProperties class
   *
   * @return    The iconDir value
   */
  public static String getIconDir() {
    return homeDir + "/lib/icons";
  }


  /**
   *  Gets the grid attribute of the AlignmentProperties object
   *
   * @return    The grid value
   */
  public boolean isGrid() {
    return grid;
  }


  /**
   *  Sets the grid attribute of the AlignmentProperties object
   *
   * @param  b  The new grid value
   */
  public void setGrid(boolean b) {
    grid = b;
  }


  /**
   *  Sets the fontSize attribute of the AlignmentProperties object
   *
   * @param  f  The new fontSize value
   */
  public void setFontSize(float f) {
    tableFont = tableFont.deriveFont(f);
    UIManager.put("Table.font", tableFont);
  }


  /**
   *  Gets the fontSize attribute of the AlignmentProperties object
   *
   * @return    The fontSize value
   */
  public float getFontSize() {
    if(tableFont == null || tableFont.getSize() < 0 || tableFont.getSize() > 16)
    {
      return 10;
    }
    return tableFont.getSize();
  }


  /**
   *  Sets the fontName attribute of the AlignmentProperties object
   *
   * @param  name  The new fontName value
   */
  public void setFontName(String name) {
    name = name.toLowerCase() + ".ttf";
    try {
      Font newFont = Font.createFont(Font.TRUETYPE_FONT, new FileInputStream(new File(getHomeDir() + "/fonts/" + name)));
      tableFont = newFont.deriveFont(getFontSize());
      UIManager.put("Table.font", tableFont);
    } catch (Exception e) {
      JOptionPane.showMessageDialog(null, "Error creating font");
      e.printStackTrace();
    }
  }


  /**
   *  Sets the background attribute of the AlignmentProperties object
   *
   * @param  c  The new background value
   */
  public void setBackground(Color c) {
    background = c;
  }


  /**
   *  Sets the textColor attribute of the AlignmentProperties object
   *
   * @param  c  The new textColor value
   */
  public void setTextColor(Color c) {
    textColor = c;
  }


  /**
   *  Gets the textColor attribute of the AlignmentProperties object
   *
   * @return    The textColor value
   */
  public Color getTextColor() {
    return textColor;
  }


  /**
   *  Gets the background attribute of the AlignmentProperties object
   *
   * @return    The background value
   */
  public Color getBackground() {
    return background;
  }

  public static void setProjectDir(String dir)
  {
    File prjDir = new File(dir);
    if(!prjDir.exists())
    {
      prjDir.mkdirs();
    }
    projectDir = dir;
  }
  
  public  void loadProgramController() throws Exception
  {
  	programController = new ProgramController();
  }
  
  public  ProgramController getProgramController() throws Exception
  {
  	if(programController == null)
  	{
  		
  		loadProgramController();
  	}
	  return programController;
  }
}

