/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.gui.tools;

import dk.kvl.alignmenttools.*;
import dk.kvl.sequencetools.*;
import java.util.*;

public class Toolbox
{
    public static Object[][] getTableArray(Alignment alignment)
    {
        Object[][] data = new Object[alignment.getNumberOfSequences()][alignment.getLength()];
        Sequence seq = null;
        int sequenceCounter = 0;
        Enumeration e = alignment.getSequenceKeys();
        while (e.hasMoreElements())
        {
            seq = alignment.getSequence((String)e.nextElement());
            for (int j = 0; j < alignment.getLength(); j++)
            {
                data[sequenceCounter][j] = new Character(seq.getSequence().charAt(j));
            }
            sequenceCounter++;
        }
        return data;
    }
    
    public static Object[][] getSequenceNames(Alignment alignment)
    {
        Object[][] names = new Object[alignment.getNumberOfSequences()][1];
        
        int counter = 0;
        Enumeration e = alignment.getSequenceKeys();
        String name = null;
        while (e.hasMoreElements())
        {
            names[counter][0] = e.nextElement();
            counter++;
        }
        return names;
    }
    
    
    public static String[] getTitleNumbers(int length)
    {
        String[] titles = new String[length];
        for (int i = 0; i<length;i++)
        {
            titles[i] = ""+(i+1);
        }
        return  titles;
    }
    
    public static String[] getTitleNumbers(int length, int startIndex)
    {
        String[] titles = new String[length];
        for (int i = 0; i<length;i++)
        {
            titles[i] = ""+(i+startIndex);
        }
        return  titles;
    }
}
