/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.sequencetools;

import java.io.Serializable;

/**
 *  A common interface for sequence alphabets
 *
 * @author     allan
 * @created    January 7, 2004
 */
public interface SequenceAlphabet 
{
    /**
     *  Description of the Field
     */
    public final static int RNAALPHABET = 1;
    public final static int PAIRINGMASK = 2;
    public final static int ARBITRARY = 3;
    /**
     *  Gets the alphabet array
     *
     * @return    The alphabet
     */
    public char[] getAlphabet();


    /**
     *  Gets the validSequence attribute of the SequenceAlphabet object
     *
     * @param  sequence  Description of the Parameter
     * @return           The validSequence value
     */
    public boolean isValidSequence(String sequence);


    /**
     *  Gets the label attribute of the SequenceAlphabet object
     *
     * @return    The label value
     */
    public String getLabel();


    /**
     *  Gets the alphabetType attribute of the SequenceAlphabet object
     *
     * @return    The alphabetType value
     */
    public int getAlphabetType();

    public boolean isValidSymbol(char aChar);
    
    public boolean isPairing(char symbol1, char symbol2);
}


