/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.tools;

import java.io.*;

/**
 *  Beregnet til at indeholde en array af inter der kan vokse dynamisk alt efter behov
 *  Den er i frste omgang skrevet til at indholde sm arrays, derfor den lille startvrdi p 2
 *
 * @author     Allan
 * @created    21. november 2003
 */
public class IntArray implements Serializable
{
    private int[] array = null;
    private int counter = 0;

    public IntArray()
    {
        this(10);
    }
    
    public IntArray(int size)
    {
        array = new int[10];
    }
    /**
     *  Inds�tter en ny int, og udvider arrayen hvis det er n�dvendigt
     *
     * @param  newInt  Description of the Parameter
     */
    public void add(int newInt)
    {
        if (counter == array.length)
        {
            int[] newArray = new int[array.length * 2];
            for (int i = 0; i < array.length; i++)
            {
                newArray[i] = array[i];
            }
            array = newArray;
        }
        array[counter] = newInt;
        counter++;
    }


    /**
     *  Returnerer den int der er indsat p� placeringen index
     *
     * @param  index  Description of the Parameter
     * @return        Description of the Return Value
     */
    public int get(int index)
    {
        return array[index];
    }


    /**
     *  Returnerer hvor mange tal der er indsat
     *
     * @return    The length value
     */
    public int getLength()
    {
        return counter;
    }


    /**  Description of the Method */
    public void reset()
    {
        array = new int[2];
        counter = 0;
    }


    /**
     *  Gets the array attribute of the IntArray object
     *
     * @return    The array value
     */
    public int[] getArray()
    {
        return array;
    }


    /**
     *  Description of the Method
     *
     * @return    Description of the Return Value
     */
    public String toString()
    {
        StringBuffer array = new StringBuffer("{");
        for (int i = 0; i < counter; i++)
        {
            if (i != 0)
            {
                array.append(",");
            }
            array.append(get(i));
        }
        array.append("}");
        return array.toString();
    }
    
    public int[] toArray()
    {
        int[] ia = new int[counter];
        System.arraycopy(array,0,ia,0,counter);
        return ia;
    }
}

