/**		SARSE, Semi-Automated RNA Sequence Editor.
 * 		Copyright (C) 2004 Allan Lind-Thomsen
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License
 *	as published by the Free Software Foundation; either version 2
 *	of the License, or (at your option) any later version.
 *	
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *	
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 **/
package dk.kvl.tools;

import org.w3c.dom.*;
import org.xml.sax.*;

/**
 *  Description of the Class
 *
 * @author     allan
 * @created    February 9, 2004
 */
public class Parameter implements Comparable
{
    private String name;
    private String description;
    private boolean inputRequired;
    private String inputDescription;
    private int numberOfInputs = 0;
    private String defaultValue;
    private String value;
    private char delimiter;
    private int number = 0;
    private boolean defaultSelected = false;
    private boolean selected = false;
    private boolean spaced;
    /**
     *  Constructor for the Parameter object
     *
     * @param  name           Description of the Parameter
     * @param  description    Description of the Parameter
     * @param  inputRequired  Description of the Parameter
     */
    public Parameter(String name, String description, boolean inputRequired)
    {
        this.name = name;
        this.description = description;
        this.inputRequired = inputRequired;
    }
    
    public Parameter(Node paramNode)
    {
        extractValues(paramNode);
    }
    
    public String getDefaultValue()
    {
        return defaultValue;
    }
    
    public void setDefaultValue(String value)
    {
        defaultValue = value;
    }
    
    
    public void extractValues(Node paramNode)
    {
        //selected
        NamedNodeMap nnm = paramNode.getAttributes();
        if(nnm.getNamedItem("selected").getNodeValue().equals("true"))
        {
            selected = true;
            defaultSelected = true;
        }
        if(nnm.getNamedItem("input").getNodeValue().equals("true"))
        {
            inputRequired = true;
        }
        if(nnm.getNamedItem("spaced").getNodeValue().equals("true"))
        {
            spaced = true;
        }
        if(nnm.getNamedItem("number") != null)
        {
            String s = nnm.getNamedItem("number").getNodeValue();
            try
            {
                number = Integer.parseInt(s); 
            }
            catch(Exception e)
            {
                e.printStackTrace();
            }
        }
        //
        NodeList nl = paramNode.getChildNodes();
        for(int i = 0;i<nl.getLength();i++)
        {
            String name = nl.item(i).getNodeName();
            
            if(name.equals("name"))
            {
		if (nl.item(i).getFirstChild().getNodeValue() != null){
		    this.name = nl.item(i).getFirstChild().getNodeValue();
		}
		else{
		    this.name = "";
		}
            }
            else if (name.equals("paramdescription"))
            {
                description = nl.item(i).getFirstChild().getNodeValue();
            }
            else if (name.equals("input"))
            {
                extractInput(nl.item(i));
            }
        }
    }

    public void extractInput(Node inputNode)
    {
        NamedNodeMap nnm = inputNode.getAttributes();
        //description
        inputDescription = nnm.getNamedItem("description").getNodeValue();
        //number
        String number = nnm.getNamedItem("number").getNodeValue();
        try
        {
            numberOfInputs = Integer.parseInt(number);
        }
        catch(Exception e)
        {
            numberOfInputs=1;
        }
        //delimiter
        String delim = nnm.getNamedItem("delimiter").getNodeValue();
        if(delim.length() == 0)
        {
            if(numberOfInputs > 1)
            {
                delimiter = ',';
            }
            
        }
        else
        {
            delimiter = delim.charAt(0);
        }
        //defaultvalue
        defaultValue = inputNode.getFirstChild().getNodeValue();
        value=defaultValue;
        }
    /**
     *  Gets the name attribute of the Parameter object
     *
     * @return    The name value
     */
    public String getName()
    {
        return name;
    }


    /**
     *  Gets the description attribute of the Parameter object
     *
     * @return    The description value
     */
    public String getDescription()
    {
        return description;
    }

    public boolean isInputRequired()
    {
        return inputRequired;
    }
    
    public String toString()
    {
        String base = name;
        if(inputRequired)
        {
        	if(spaced){
        		return name+" "+defaultValue.trim();
        	}else
        	{
        		return name+defaultValue.trim();
        	}
        }
        return name;
    }
    

    public boolean isSelected()
{
    	return selected;
}

public void setSelected(boolean sel)
{
    selected = sel;
}

    /**
     *  Description of the Method
     *
     * @param  programObject  Description of the Parameter
     * @return                Description of the Return Value
     */
    public int compareTo(Object parameterObject)
    {
        Parameter p = (Parameter)parameterObject;
        return getName().compareTo(p.getName());
    }
    
    
    public int getNumber()
    {
        return number;
    }

	
    public void reset(){
    	if(defaultValue != null){
    		value= defaultValue;
    	}
    	if(defaultSelected){
    		selected = true;
    	}else{
    		selected = false;
    	}
    }

	public boolean isDefaultSelected() {
		return defaultSelected;
	}
}

