package dk.kvl.tools.io;

import java.io.*;
import dk.kvl.tools.io.*;
import dk.kvl.tools.*;

public class ErrorReaderThread extends Thread{
    private BufferedReader br;
    private Log log;
    private Program p;
    
    public ErrorReaderThread(BufferedReader br, Log log, Program p){
	this.br = br;
	this.log = log;
	this.p = p;
    }
    
    public void run(){
	try{
	    String errorLine = br.readLine();
	    if (errorLine != null)
	    {
		log.writeLine("ERROR IN: " + p.getName());
		p.setError(true);
	    }
	    while (errorLine != null)
	    {
		if(errorLine.length() != 0)
		{
		    log.writeLine(errorLine);
		}
		errorLine = br.readLine();
	    }
	}
	catch(IOException e){
	    System.out.println("Error in ErrorReaderThread");
	}
    }
}
