#!/usr/bin/nawk -f

# Jan Gorodkin
# Center for Biological Sequence Analysis
# The Technical University of Denmark
# B206, DK-2800 Lyngby
# Denmark
# gorodkin@cbs.dtu.dk

# example to execute
# logo2structlogo.awk alignfile logo.ps


BEGIN{wout=0; tmp=0; position=11; k=1;}
{
  if(FNR==1) count++;

  if(count==1 && FNR==1) for(i=1;i<length($2)+1;i++) struct[i]=substr($2,i,1);

  if(count==2)
  {

     print $0;

     if($1=="/makenumber") tmp=1;

     if($0=="} bind def" && tmp==1) wout=1;

     if(wout==1)
     {
       printf("\n");
       print "/makeassign \{ % number makeassign";
       print "gsave";
       print "  shift % shift to the other side of the stack";
       print "  dup stringwidth pop % find the length of the number";
       print "  neg % prepare for move";
       print "  charwidth (0) charparams uy ly sub % height of numbers";
       print "  sub -"position"  mul %";
       print "  moveto % move back to provide space";
       print "  show";
       print "grestore";
       print "\} bind def";
       printf("\n");
       wout=0;
     }

     if($2=="\)" && $3=="makenumber")
     {
        if(struct[k]!="\(" && struct[k]!="\)" && struct[k]!="\[" && struct[k]!="\]" && struct[k]!="\<" && struct[k]!="\>" && struct[k]!="\{" && struct[k]!="\}" ) print "\( "struct[k]" \) makeassign";
        else print "\( \\"struct[k]" \) makeassign";

        k++;
     }
  }

}
END{}
